﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace SWAT_USB_App
{
    public partial class Main_Menu_Form : Form
    {
        public Main_Menu_Form()
        {
            Initialization.Initialize();
            Debug.startNewSession();
            Debug.appendText("Main menu form initializing");
            Debug.appendText("SWAT Drive detected as drive " + Initialization.pathToSWATDrive);
            InitializeComponent();
            this.KeyPreview = true;
            this.KeyPress += new KeyPressEventHandler(this.form_Main_Menu_KeyPress);
            this.FormClosing += new FormClosingEventHandler(form_Main_Menu_FormClosing);
            if (!SettingsParser.settingsFileExist())
            {
                Debug.appendText("USBSettings.xml cannot be found");
                MessageBox.Show("USBSettings.xml cannot be found.", "Error");
            }
            else
            {
                SettingsParser.readSettingsFile();
            }
        }
        private void btn_Main_Drivers_Click(object sender, EventArgs e)
        {
            if (SettingsParser.DriversList.Count() == 0)
            {
                Debug.appendText("No drivers were found in USBSettings.xml or file does not exist");
                MessageBox.Show("No drivers were found in USBSettings.xml or file does not exist");
            }
            else
            {
                Drivers_Form driverForm = new Drivers_Form();
                //this.WindowState = FormWindowState.Minimized;
                driverForm.ShowDialog();
                //this.WindowState = FormWindowState.Normal;
            }
        }
        private void btn_Main_Software_Click(object sender, EventArgs e)
        {
            if (SettingsParser.ApplicationsList.Count() == 0)
            {
                Debug.appendText("No drivers were found in USBSettings.xml or file does not exist");
                MessageBox.Show("No drivers were found in USBSettings.xml or file does not exist");
            }
            else
            {
                Software_Form softwareForm = new Software_Form();
                //this.WindowState = FormWindowState.Minimized;
                softwareForm.ShowDialog();
                //this.WindowState = FormWindowState.Normal;
            }
        }
        private void btn_Main_Exit_Click(object sender, EventArgs e)
        {
            if (System.IO.File.Exists("Debug.txt"))
                Debug.appendText("Closing main menu form");
            this.Close();
        }
        private void form_Main_Menu_KeyPress(object sender, KeyPressEventArgs e)
        // Enables keyboard control for button navigation
        {
            switch (e.KeyChar)
            {
                case 'd':
                case 'D':
                    Drivers_Form driverForm = new Drivers_Form();
                    driverForm.ShowDialog();
                    break;
                case 's':
                case 'S':
                    Software_Form softwareForm = new Software_Form();
                    softwareForm.ShowDialog();
                    break;
                case '?':
                    About_Box_Form aboutForm = new About_Box_Form();
                    aboutForm.ShowDialog();
                    break;
            }
        }
        void form_Main_Menu_FormClosing(object sender, FormClosingEventArgs e)
        {
            try
            {
                // If the application is located in the startup folder, prompt for removal on exit
                if (System.IO.Directory.GetCurrentDirectory() == System.Environment.SystemDirectory)
                {
                    // If user chooses to remove the program from startup, initializes code to delete the exe after program exits
                    DialogResult result;
                    result = MessageBox.Show("Would you like to remove this menu from startup?", "Remove from startup?", MessageBoxButtons.YesNo);
                    if (result == DialogResult.Yes)
                    {
                        ProcessStartInfo Info = new ProcessStartInfo();
                        // Calls up a hidden command prompt with a timeout of 3 seconds, automatically chooses yes to delete
                        Info.Arguments = "/C choice /C Y /N /D Y /T 3 & Del \"" + Application.ExecutablePath + "\"";
                        Info.WindowStyle = ProcessWindowStyle.Hidden;
                        Info.CreateNoWindow = true;
                        Info.FileName = "cmd.exe";
                        Process.Start(Info);
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.appendText("Exception Thrown: " + ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }
    }
}
